/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.HashMap;
import java.util.Map;

public class FilterManagerPanelBean
extends PanelBean
implements NotificationConstants {
    private static final String TRACE_MASKT = "XNTYFMPT";
    private static final String TRACE_MASKF = "XNTYFMPF";
    private static final String TRACE_MASKD = "XNTYFMPD";
    private transient ItemDescriptor[] m_idFilterTable;
    private transient ColumnDescriptor[] m_cdFilterTableStructure;
    private int[] m_iFilterTableSelection;
    private Map data;
    public static final String FILTER_TABLE = "FilterTable";
    public static final String TASKLET_SELECTED_FILTER = "TaskletSelectedFilter";

    public void setFilterTableSelection(int[] selected) throws IllegalUserDataException {
        if (selected != null && selected.length > 0) {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", true);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", true);
        } else {
            this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
            this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
        }
        this.m_iFilterTableSelection = selected;
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction()");
        String command = event.getActionCommand();
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        request.setData("CommandSource", "FilterManagerPanel");
        String filter = null;
        String[] filters = null;
        if (this.m_iFilterTableSelection != null && this.m_iFilterTableSelection.length > 0) {
            filters = new String[this.m_iFilterTableSelection.length];
            Map[] filtersMap = (Map[])this.data.get(FILTER_TABLE);
            for (int i = 0; i < this.m_iFilterTableSelection.length; ++i) {
                filters[i] = (String)filtersMap[this.m_iFilterTableSelection[i]].get("DataMapName");
            }
            filter = filters[0];
        } else {
            filters = new String[]{};
        }
        if (command.equals(this.getMountPrefix() + "OKButton")) {
            request.setData(TASKLET_SELECTED_FILTER, filters);
            request.setData("CommandName", "OKButton");
        } else if (command.equals(this.getMountPrefix() + "AddButton")) {
            request.setData("CommandName", "AddButton");
        } else if (command.equals(this.getMountPrefix() + "EditButton")) {
            if (filter.equals("")) {
                request = null;
            } else {
                request.setData("CommandName", "EditButton");
                request.setData(TASKLET_SELECTED_FILTER, filter);
            }
        } else if (command.equals(this.getMountPrefix() + "DeleteButton")) {
            if (filter.equals("")) {
                request = null;
            } else {
                request.setData("CommandName", "DeleteButton");
                request.setData(TASKLET_SELECTED_FILTER, filter);
            }
        }
        if (request != null) {
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void update(Object o) {
        Trace.trace(TRACE_MASKT, "<> update");
        if (o instanceof Map) {
            Map map = (Map)o;
            String command = (String)map.get("CommandName");
            Map[] filters = (Map[])this.data.get(FILTER_TABLE);
            if (command.equals("DeleteButton")) {
                Trace.trace(TRACE_MASKF, "deleting a row");
                Map[] newFilters = new Map[filters.length - 1];
                System.arraycopy(filters, 0, newFilters, 0, this.m_iFilterTableSelection[0]);
                System.arraycopy(filters, this.m_iFilterTableSelection[0] + 1, newFilters, this.m_iFilterTableSelection[0], newFilters.length - this.m_iFilterTableSelection[0]);
                this.data.put(FILTER_TABLE, newFilters);
                this.userTaskManager.setSelectedRows(this.getMountPrefix() + FILTER_TABLE, new int[0]);
                this.setFilterTableSelection(new int[0]);
            } else if (command.equals("AddButton")) {
                Map[] newFilters = new Map[filters.length + 1];
                System.arraycopy(filters, 0, newFilters, 0, filters.length);
                HashMap newFilter = new HashMap();
                newFilter.put("DataMapName", map.get("DataMapName"));
                newFilter.put("DataMapDesc", map.get("DataMapDesc"));
                newFilters[filters.length] = newFilter;
                this.data.put(FILTER_TABLE, newFilters);
            } else if (command.equals("EditButton")) {
                filters[this.m_iFilterTableSelection[0]].put("DataMapName", map.get("DataMapName"));
                filters[this.m_iFilterTableSelection[0]].put("DataMapDesc", map.get("DataMapDesc"));
            }
            this.userTaskManager.refreshAllElements();
        }
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> save()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        if (this.data == null) {
            this.data = new HashMap();
        } else {
            int[] selectedFilterIndicies;
            Map[] filters = (Map[])this.data.get(FILTER_TABLE);
            String[] selectedFilters = (String[])this.data.get(TASKLET_SELECTED_FILTER);
            if (selectedFilters == null) {
                selectedFilterIndicies = new int[]{};
                selectedFilters = new String[]{};
            } else {
                selectedFilterIndicies = new int[selectedFilters.length];
            }
            int selectedFilterIndex = 0;
            Trace.trace(TRACE_MASKF, "number of filters to look for: " + selectedFilters.length);
            if (filters != null) {
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i] == null) continue;
                    for (int j = 0; j < selectedFilters.length; ++j) {
                        if (!selectedFilters[j].equals((String)filters[i].get("DataMapName"))) continue;
                        selectedFilterIndicies[selectedFilterIndex++] = i;
                        Trace.trace(TRACE_MASKF, "found a filter");
                    }
                }
                if (selectedFilterIndicies.length > 0) {
                    this.userTaskManager.setSelectedRows(this.getMountPrefix() + FILTER_TABLE, (int[])selectedFilterIndicies.clone());
                    this.m_iFilterTableSelection = (int[])selectedFilterIndicies.clone();
                } else {
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "EditButton", false);
                    this.userTaskManager.setEnabled(this.getMountPrefix() + "DeleteButton", false);
                }
            } else {
                this.data.put(FILTER_TABLE, new Map[0]);
            }
        }
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void load() {
        this.m_idFilterTable = new ItemDescriptor[0];
        this.m_cdFilterTableStructure = new ColumnDescriptor[0];
        this.m_iFilterTableSelection = new int[0];
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getFilterTableRowCount() {
        Map[] filters = (Map[])this.data.get(FILTER_TABLE);
        return filters.length;
    }

    public ItemDescriptor[] getFilterTableRowAt(int index) {
        Map[] filters = (Map[])this.data.get(FILTER_TABLE);
        ItemDescriptor col1 = new ItemDescriptor(this.getMountPrefix() + "name_" + index, (String)filters[index].get("DataMapName"));
        ItemDescriptor col2 = new ItemDescriptor(this.getMountPrefix() + "desc_" + index, (String)filters[index].get("DataMapDesc"));
        return new ItemDescriptor[]{col1, col2};
    }

    public ColumnDescriptor[] getFilterTableRowStructure() {
        return this.m_cdFilterTableStructure;
    }

    public int getFilterTableRowStatus() {
        return 3;
    }

    public void setFilterTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idFilterTable = items;
    }

    public int[] getFilterTableSelection() {
        return this.m_iFilterTableSelection;
    }
}

